/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.InvisibilityPower;
import io.github.apace100.origins.power.ModelColorPower;
import io.github.apace100.origins.power.ShakingPower;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={LivingRenderer.class})
public abstract class LivingEntityRendererMixin
extends EntityRenderer<LivingEntity> {
    protected LivingEntityRendererMixin(EntityRendererManager dispatcher) {
        super(dispatcher);
    }

    @Inject(method={"isShaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void letPlayersShakeTheirBodies(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        if (OriginComponent.hasPower((Entity)entity, ShakingPower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPumpkinRendering(LivingEntity livingEntity, float f, float g, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i, CallbackInfo info) {
        List<InvisibilityPower> invisibilityPowers = OriginComponent.getPowers((Entity)livingEntity, InvisibilityPower.class);
        if (invisibilityPowers.size() > 0 && invisibilityPowers.stream().noneMatch(InvisibilityPower::shouldRenderArmor)) {
            info.cancel();
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;", shift=At.Shift.BEFORE))
    private RenderType changeRenderLayerWhenTranslucent(RenderType original, LivingEntity entity) {
        if (entity instanceof PlayerEntity && OriginComponent.getPowers((Entity)entity, ModelColorPower.class).stream().anyMatch(ModelColorPower::isTranslucent)) {
            return RenderType.func_239268_f_((ResourceLocation)this.func_110775_a((Entity)entity));
        }
        return original;
    }

    @ModifyArgs(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V", ordinal=0))
    @OnlyIn(value=Dist.CLIENT)
    private <T extends LivingEntity> void renderColorChangedModel(Args args, LivingEntity player, float f, float g, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i) {
        List<ModelColorPower> modelColorPowers;
        if (player instanceof PlayerEntity && !(modelColorPowers = OriginComponent.getPowers((Entity)player, ModelColorPower.class)).isEmpty()) {
            int red = args.size() - 4;
            int green = args.size() - 3;
            int blue = args.size() - 2;
            int alpha = args.size() - 1;
            args.set(red, (Object)Float.valueOf(((Float)args.get(red)).floatValue() * modelColorPowers.stream().map(ModelColorPower::getRed).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue()));
            args.set(green, (Object)Float.valueOf(((Float)args.get(green)).floatValue() * modelColorPowers.stream().map(ModelColorPower::getGreen).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue()));
            args.set(blue, (Object)Float.valueOf(((Float)args.get(blue)).floatValue() * modelColorPowers.stream().map(ModelColorPower::getBlue).reduce(Float.valueOf(1.0f), (a, c) -> Float.valueOf(a.floatValue() * c.floatValue())).floatValue()));
            args.set(alpha, (Object)Float.valueOf(((Float)args.get(alpha)).floatValue() * modelColorPowers.stream().map(ModelColorPower::getAlpha).min(Float::compare).orElseThrow(RuntimeException::new).floatValue()));
        }
    }
}

